#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

float character(int n, vec2 p)
{
	p = floor(p*(vec2)(4.0f, -4.0f) + 2.5f);
    if (clamp(p.x, 0.0f, 4.0f) == p.x)
	{
        if (clamp(p.y, 0.0f, 4.0f) == p.y)	
		{
        	int a = (int)(round(p.x) + 5.0f * round(p.y));
			if (((n >> a) & 1) == 1) return 1.0f;
		}	
    }
	return 0.0f;
}

float myMod(float x,float y){
    return x - y * floor(x/y);
}

__kernel void MAIN(
      __read_only image2d_t input,  
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha,
      int Gray) 
{
    int outputW = param->width[1];
	int outputH = param->height[1];
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 ouputResolution = (float2)(W,H);
  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/ouputResolution.xy;
    vec2 resolution = ouputResolution;
    float roiLeft = param->origROI[0];
    float roiTop = param->origROI[1];
    float roiWidth  = param->origROI[2];
    float roiHeight  = param->origROI[3];
    //vec2 tranformCoord = (vec2)(roiWidth * tc.x + roiLeft , roiHeight * tc.y + roiTop);
    tc = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
    
    float4 orig = read_imagef(input, sampler, tc);  

    vec2 pix = fragCoord.xy;
	vec3 col = orig.rgb;	
	
	float gray = 0.3f * col.x + 0.59f * col.y + 0.11f * col.z;
	
	int n =  4096;                // .
	if (gray > 0.2) n = 65600;    // :
	if (gray > 0.3) n = 332772;   // *
	if (gray > 0.4) n = 15255086; // o 
	if (gray > 0.5) n = 23385164; // &
	if (gray > 0.6) n = 15252014; // 8
	if (gray > 0.7) n = 13199452; // @
	if (gray > 0.8) n = 11512810; // #
	
	float factor = ouputResolution.x / 640.0f;
	vec2 p = fmod(pix/(4.0f*factor), 2.0f) - (vec2)(1.0f);
    
    if(Gray > 0)
	{
        col = gray*(vec3)(character(n, p));
    }
	else 
    {
        col = col*character(n, p);
    }  	    
    vec4 fragColor = (vec4)(col.x,col.y,col.z,orig.w);
    vec4 retColor =  mix( fragColor, orig, 1.0f - (float)(alpha)/100.0f );   
    write_imagef(dest_data,gl_FragCoord,retColor);
}



